/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_rdma_read.c,v 1.9 2005/06/29 00:23:16 eugene Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"
#include "rdma.h"

mx_return_t
mx_rdma_read(mx_endpoint_t endpoint,
             mx_segment_t *segments_list,
             uint32_t segments_count,
             mx_endpoint_addr_t target,
             uint32_t window_handle,
             uint32_t offset,
             void *context,
             mx_request_t *request){
  static struct mx_get_request getreq;
  mx_segment_t seg;
  mx_request_t sreq;
  mx_return_t ret;
  uint64_t match_recv;

  getreq.handle = window_handle;
  getreq.offset = offset;
  getreq.len = mx_segment_list_len(segments_list, segments_count);
  seg.segment_ptr = &getreq;
  seg.segment_length = sizeof(getreq);

  ret = mx_isend_with_type(endpoint, &seg, 1, target, 
                           0, NULL, &sreq, MX_SR_TYPE_GET,
                           0, 0, 0);
  if (ret != MX_SUCCESS){
    return ret;
  }

  match_recv = MX_UINT64(sreq);

  ret = mx_irecv_with_type(endpoint, segments_list, segments_count,
			   match_recv,
			   MX_MATCH_MASK_NONE, NULL, 
                           request, MX_SR_TYPE_GET_DATA);
  if (ret != MX_SUCCESS){
    return ret;
  }
  
  return MX_SUCCESS;
}

